﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Security;
using BMS.VistaIntegration.FacadeContracts;
using BMS.Facade;
using BMS.Utils;
using FacadeVistASite = BMS.VistaIntegration.FacadeContracts.VistASite;
using BMS.Schedulers;
using BMS.VistaIntegration.FacadeContracts.Admin;

namespace BMS.Schedulers.Managers
{
    public class SchedulerManager
    {
        private static SchedulerManager instance = new SchedulerManager();
        private bool isClosed = true;
        private SchedulerTimer schedulerTimer = new SchedulerTimer();

        public static SchedulerManager Instance { get { return instance; } }

        public void Start()
        {
            if (!isClosed)
                throw new InvalidOperationException("Already started");

            isClosed = false;
            RefreshSchedulers();
            schedulerTimer.Start();
        }

        public void Close()
        {
            if (isClosed) return;
            isClosed = true;
            schedulerTimer.Stop();
        }

        public void Dispose()
        {
            Close();
        }

        public void RemoveCommands<T>() where T : ICommand
        {
            foreach (var scheduler in schedulerTimer.Schedulers)            
                scheduler.RemoveCommand<T>();            
        }

        public void SetCommands<T>(IDictionary<string,T> commands) where T : ICommand
        {
            foreach (Scheduler scheduler in schedulerTimer.Schedulers)
            {
                T command;
                if (commands.TryGetValue(scheduler.Id, out command))                
                    scheduler.SetCommand(command);                
                else                
                    scheduler.RemoveCommand<T>();                
            }
        }

        public void RefreshSchedulers()
        {
            IEnumerable<Scheduler> schedulers = ReadSchedulers();
            schedulerTimer.Setchedulers(schedulers);
        }

        private IEnumerable<Scheduler> ReadSchedulers()
        {
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();

            IList<JobCalendar> calendars = FacadeManager.ConfigurationInterface.GetDefinedCalendars(domain);
            return calendars.Select(Translator.ToScheduler);
        }

        public void SetRefreshSchedulersFlag()
        {
            schedulerTimer.SetRefreshSchedulersFlag();
        }

        public void SetRefreshVistACommandsFlag()
        {
            schedulerTimer.SetRefreshVistACommandsFlag();
        }

        public void SetRefreshNumiCommandsFlag()
        {
            schedulerTimer.SetRefreshNumiCommandsFlag();
        }

        public void SetRefreshWhiteboardReportCommandsFlag()
        {
            schedulerTimer.SetRefreshWhiteboardReportCommandsFlag();
        }
    }
}
